clear all

* Set Folder to input one

cd ..\Inputs

* Import and clean output gap data

import excel "Vintages of Real GDP.xlsx", ///
sheet(ROUTPUT) cellrange(A1) firstrow clear

foreach v of varlist ROUTPUT* {
	destring `v', replace force
}

drop if DATE==""

* Generate date related variables

gen t=_n
gen year=substr(DATE,1,4)
destring year, replace force
gen quarter=substr(DATE,7,1)
destring quarter, replace force
order t year quarter DATE
tsset t

* Generate growth rates

foreach v of varlist ROUTPUT* {
	gen G`v'=(`v'-L.`v')/L.`v'*400
}

* Save vintages

save vin_rgdp, replace

* Generate growth rates of output

drop if year<1960
gen GYreal=.

quiet forvalues yearl=1960(1)2016 {
	forvalues quarterl=1(1)4 {
		capture {
			local yeartwol=substr("`yearl'",3,2)
			local yeartwolp1=string(`yeartwol'+1,"%02.0f")
			if `yeartwol'==99 { 
				local yeartwolp1=string(0,"%02.0f")
			}
			n replace GYreal=GROUTPUT`yeartwol'Q`=`quarterl'+1' if year==`yearl' & quarter==`quarterl' & quarter!=4
			n replace GYreal=GROUTPUT`yeartwolp1'Q1 if year==`yearl' & quarter==4
		}
	}
}

gen GYlast=GROUTPUT17Q1

* Generate HP filter

local i=1
quiet foreach lambda of numlist 800(800)4000 5000(5000)20000 25000(50000)325000 ///
                          500000(500000)2000000 4000000(2000000)12000000 {
	noisily di `lambda'
	noisily di `i'
	foreach v of varlist GROUTPUT* {
		tsfilter hp hpc`v'`i' = `v', smooth(`lambda') trend(hpt`v'`i')
	}
	gen hpGY`i'=.
	forvalues yearl=1960(1)2016 {
		forvalues quarterl=1(1)4 {
			capture {
				local yeartwol=substr("`yearl'",3,2)
				local yeartwolp1=string(`yeartwol'+1,"%02.0f")
				if `yeartwol'==99 { 
					local yeartwolp1=string(0,"%02.0f")
				}
				replace hpGY`i'=hptGROUTPUT`yeartwol'Q`=`quarterl'+1' if year==`yearl' & quarter==`quarterl' & quarter!=4
				replace hpGY`i'=hptGROUTPUT`yeartwolp1'Q1 if year==`yearl' & quarter==4
			}
		}
	}
	drop hpc*`i' hpt*`i'
	label var hpGY`i' "last observation of hp filtered real time data, lambda=`lambda'"
	local ++i
}

local i=1
quiet foreach lambda of numlist 800(800)4000 5000(5000)20000 25000(50000)325000 ///
                          500000(500000)2000000 4000000(2000000)12000000 {
	noisily di `lambda'
	noisily di `i'
	tsfilter hp hclast = GROUTPUT17Q1, smooth(`lambda') trend(hlGY`i')
	label var hlGY`i' "hp filtered last vintage, lambda=`lambda'"
	drop hclast
	local ++i
}

* Generate Moving Averages

quiet forvalues terms=1(1)40 {
	noisily di `terms'
	foreach v of varlist GROUTPUT* {
		quietly tssmooth ma MA`v'=`v', window(`=`terms'-1' 1 0)
	}
	gen maGY`terms'=.
	forvalues yearl=1960(1)2016 {
		forvalues quarterl=1(1)4 {
			capture {
				local yeartwol=substr("`yearl'",3,2)
				local yeartwolp1=string(`yeartwol'+1,"%02.0f")
				if `yeartwol'==99 { 
					local yeartwolp1=string(0,"%02.0f")
				}
				replace maGY`terms'=MAGROUTPUT`yeartwol'Q`=`quarterl'+1' if year==`yearl' & quarter==`quarterl' & quarter!=4
				replace maGY`terms'=MAGROUTPUT`yeartwolp1'Q1 if year==`yearl' & quarter==4
			}
		}
	}
	drop MAGRO*
	label var maGY`terms' "last observation of MA(`terms') smoothed real time data"
}

* Generate Moving Median

quiet forvalues terms=2(1)40 {
	noisily di `terms'
	foreach v of varlist GROUTPUT* {
		quietly mvsumm `v', generate(mm`v') stat(median) window(`terms') end force
	}
	gen mmGY`terms'=.
	forvalues yearl=1960(1)2016 {
		forvalues quarterl=1(1)4 {
			capture {
				local yeartwol=substr("`yearl'",3,2)
				local yeartwolp1=string(`yeartwol'+1,"%02.0f")
				if `yeartwol'==99 { 
					local yeartwolp1=string(0,"%02.0f")
				}
				replace mmGY`terms'=mmGROUTPUT`yeartwol'Q`=`quarterl'+1' if year==`yearl' & quarter==`quarterl' & quarter!=4
				replace mmGY`terms'=mmGROUTPUT`yeartwolp1'Q1 if year==`yearl' & quarter==4
			}
		}
	}
	drop mmGRO*
	label var mmGY`terms' "last observation of MM(`terms') smoothed real time data"
}

drop t DATE

* Change to output folder and save

cd ..\Outputs
save VINRGDPG, replace
